/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.AcceptedUpdatesBean;
import com.ibm.hwmca.base.updates.AllMCFFileFilter;
import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeBean;
import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeConstants;
import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeResponseData;
import com.ibm.hwmca.base.updates.ECStream;
import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.util.IssueCmd;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesBusyInterface;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Update;
import com.ibm.hwmca.xfw.updates.UpdateCollection;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateStyle;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class AnalyzeConsoleIntCodeTasklet
extends PanelTasklet
implements AnalyzeConsoleIntCodeConstants,
CommonMsgInterface,
ProgressEndedListener,
UpdatesErrorIds,
MediaServicesBusyInterface {
    private static final String TRACE_MASKT = "XMCFACTT";
    private static final String TRACE_MASKF = "XMCFACTF";
    private static final String TRACE_MASKD = "XMCFACTD";
    private static String baseBundleName = BaseTextBundle.getBundleName();
    UpdateManager theUpdateManager = UpdateManager.getUpdateManager();
    List allUpdatesList;
    private List tableData = null;
    private Update selectedUpdate = null;
    UpdateStyle updateStyle = null;
    PanelHandler currentPanel;
    private int mediaType;
    private File searchArea;
    private boolean isBusyDesiredForMediaOperations = true;
    private LocalizableText busyMessage = null;
    private PanelTaskletProgressListener savedProgListener;
    private static final String PROGRESS_PANEL_ID = "AnalyzeConsoleProgID";
    private boolean progressDismissed = false;
    private LocalizableText importCompletionMessage = null;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "AnalyzeConsoleIntCodeTasklet");
    PanelHandler AnalyzeConsoleIntCodePanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            block31: {
                Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.AnalyzeConsoleIntCodePanelHandler.service()");
                try {
                    if (request.isDisposed() || request.isCanceled()) {
                        Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKF, " [AnalyzeConsoleIntCodePanelHandler.service()] Terminate task because the main panel is being disposed.");
                        response.terminate();
                        break block31;
                    }
                    String eventName = ((TaskActionEvent)request.getData("event")).getElementName();
                    Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKF, " [AnalyzeConsoleIntCodePanelHandler.service()] The event name is '" + eventName + "'");
                    if (eventName.equalsIgnoreCase("ViewMenu.AccepInterCodeFixItem")) {
                        AcceptedUpdatesBean bean = new AcceptedUpdatesBean();
                        List committedUpdates = AnalyzeConsoleIntCodeTasklet.this.getAllCommittedUpdates();
                        if (committedUpdates.size() > 0) {
                            bean.setPanelData(committedUpdates);
                            AnalyzeConsoleIntCodeTasklet.this.currentPanel = AnalyzeConsoleIntCodeTasklet.this.AcceptedUpdatesPanelHandler;
                            response.openModalChild("com.ibm.hwmca.base.updates.res.AnalyzeConsoleIntCodeRes", "AcceptedUpdatesPanel", bean);
                        } else {
                            AnalyzeConsoleIntCodeTasklet.this.showMessage("MCF8003", "MCF0003");
                            response.noAction();
                        }
                        break block31;
                    }
                    if (eventName.equalsIgnoreCase("FileMenu.RetrieveFromDisketteItem") || eventName.equalsIgnoreCase("FileMenu.RetrieveFromDvdItem")) {
                        Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKF, " [AnalyzeConsoleIntCodePanelHandler.service()] - Processing retrieve MCF from media request");
                        AnalyzeConsoleIntCodeTasklet.this.mediaType = 1;
                        if (eventName.equalsIgnoreCase("FileMenu.RetrieveFromDvdItem")) {
                            AnalyzeConsoleIntCodeTasklet.this.mediaType = 6;
                        }
                        AnalyzeConsoleIntCodeTasklet.this.handleRetrieveRequest(response);
                        break block31;
                    }
                    int[] selectedRows = (int[])request.getData("selected");
                    Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKD, " [AnalyzeConsoleIntCodePanelHandler.service()] The selected rows are: ");
                    for (int i = 0; i < selectedRows.length; ++i) {
                        Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKD, " [AnalyzeConsoleIntCodePanelHandler.service()]    row number: " + selectedRows[i]);
                    }
                    if (eventName.equalsIgnoreCase("FileMenu.DeleteItem")) {
                        ArrayList<MessageText> completionMsgList = new ArrayList<MessageText>(selectedRows.length + 1);
                        String operationTypeName = "Delete";
                        for (int i = 0; i < selectedRows.length; ++i) {
                            block32: {
                                Update update = (Update)AnalyzeConsoleIntCodeTasklet.this.allUpdatesList.get(selectedRows[i] - i);
                                try {
                                    update.delete();
                                    MessageText completionMsg = update.getLastMessage();
                                    if (null == completionMsg) break block32;
                                    completionMsgList.add(completionMsg);
                                }
                                catch (Exception e) {
                                    MessageText errorMsg = update.getLastMessage();
                                    if (null != errorMsg) {
                                        ArrayList<MessageText> messageList = new ArrayList<MessageText>(1);
                                        messageList.add(errorMsg);
                                        String[] rowData = (String[])AnalyzeConsoleIntCodeTasklet.this.tableData.get(selectedRows[i] - i);
                                        String[] introMsgSubstitutions = new String[]{operationTypeName, rowData[0]};
                                        AnalyzeConsoleIntCodeTasklet.this.showMessage("MCF8002", "MCF0001", introMsgSubstitutions, messageList);
                                    }
                                    ArrayList<Integer> changedRows = new ArrayList<Integer>(1);
                                    changedRows.add(new Integer(selectedRows[i]));
                                    AnalyzeConsoleIntCodeTasklet.this.refreshLocalUpdateData(changedRows);
                                    break;
                                }
                            }
                            AnalyzeConsoleIntCodeTasklet.this.allUpdatesList.remove(selectedRows[i] - i);
                            AnalyzeConsoleIntCodeTasklet.this.tableData.remove(selectedRows[i] - i);
                        }
                        if (completionMsgList.size() > 0) {
                            AnalyzeConsoleIntCodeTasklet.this.showMessage("MCF8001", "MCF0002", new String[]{operationTypeName}, completionMsgList);
                        }
                        response.update("AnalyzeConsoleIntCodePanel", AnalyzeConsoleIntCodeTasklet.this.getResponseData());
                        break block31;
                    }
                    if (eventName.equalsIgnoreCase("OptionsMenu.ActInterCodeFixItem") || eventName.equalsIgnoreCase("OptionsMenu.DeActInterCodeFixItem")) {
                        String operationTypeName;
                        boolean doApply;
                        ArrayList<MessageText> completionMsgList = new ArrayList<MessageText>(selectedRows.length + 1);
                        if (eventName.equalsIgnoreCase("OptionsMenu.ActInterCodeFixItem")) {
                            doApply = true;
                            operationTypeName = "Activate internal code fix";
                        } else {
                            doApply = false;
                            operationTypeName = "Deactivate internal code fix";
                        }
                        ArrayList<Integer> changedRows = new ArrayList<Integer>(selectedRows.length);
                        for (int i = 0; i < selectedRows.length; ++i) {
                            block33: {
                                Update update = (Update)AnalyzeConsoleIntCodeTasklet.this.allUpdatesList.get(selectedRows[i]);
                                try {
                                    if (doApply) {
                                        update.apply();
                                    } else {
                                        update.reject();
                                    }
                                    MessageText completionMsg = update.getLastMessage();
                                    if (null == completionMsg) break block33;
                                    completionMsgList.add(completionMsg);
                                }
                                catch (Exception e) {
                                    MessageText errorMsg = update.getLastMessage();
                                    if (null != errorMsg) {
                                        ArrayList<MessageText> messageList = new ArrayList<MessageText>(1);
                                        messageList.add(errorMsg);
                                        String[] rowData = (String[])AnalyzeConsoleIntCodeTasklet.this.tableData.get(selectedRows[i]);
                                        String[] introMsgSubstitutions = new String[]{operationTypeName, rowData[0]};
                                        AnalyzeConsoleIntCodeTasklet.this.showMessage("MCF8002", "MCF0001", introMsgSubstitutions, messageList);
                                    }
                                    changedRows.add(new Integer(selectedRows[i]));
                                    break;
                                }
                            }
                            changedRows.add(new Integer(selectedRows[i]));
                        }
                        AnalyzeConsoleIntCodeTasklet.this.refreshLocalUpdateData(changedRows);
                        if (completionMsgList.size() > 0) {
                            AnalyzeConsoleIntCodeTasklet.this.showMessage("MCF8001", "MCF0002", new String[]{operationTypeName}, completionMsgList);
                        }
                        response.update("AnalyzeConsoleIntCodePanel", AnalyzeConsoleIntCodeTasklet.this.getResponseData());
                        break block31;
                    }
                    if (eventName.equalsIgnoreCase("ViewMenu.InterCodeFixInfoItem")) {
                        if (null != AnalyzeConsoleIntCodeTasklet.this.updateStyle) {
                            String[] rowData = (String[])AnalyzeConsoleIntCodeTasklet.this.tableData.get(selectedRows[0]);
                            AnalyzeConsoleIntCodeTasklet.this.selectedUpdate = (Update)AnalyzeConsoleIntCodeTasklet.this.allUpdatesList.get(selectedRows[0]);
                            Hashtable<String, String[]> initData = new Hashtable<String, String[]>(2);
                            initData.put("rowData", rowData);
                            DisplayAreaDescriptorDelegate subtaskDelegate = AnalyzeConsoleIntCodeTasklet.this.updateStyle.getAnalyzeCodeFixInformationPanelDelegate();
                            subtaskDelegate = new DisplayAreaDescriptorDelegate(subtaskDelegate.getSubTaskletName(), initData);
                            if (null != subtaskDelegate) {
                                Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, " [AnalyzeConsoleIntCodePanelHandler.service()] Open subtasklet to display tower-specific extended code fix info.");
                                response.openModalChild(subtaskDelegate);
                            } else {
                                Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, " [AnalyzeConsoleIntCodePanelHandler.service()] Got NULL subtasklet delegate. Ignore request for tower-specific code fix info.");
                                response.noAction();
                            }
                        } else {
                            Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKD, " [AnalyzeConsoleIntCodePanelHandler.service()] No update style to use. Ignore request for tower-specific code fix info.");
                            response.noAction();
                        }
                    } else {
                        Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKF, " [AnalyzeConsoleIntCodePanelHandler.service()] Ignore unknown event '" + eventName + "'");
                        response.noAction();
                    }
                }
                catch (Exception e) {
                    Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, " [AnalyzeConsoleIntCodePanelHandler.service()] caught exception: " + e);
                    e.printStackTrace();
                    new FrameworkLog(classLogInfo, -4347, e).log();
                    Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, " [AnalyzeConsoleIntCodePanelHandler.service()] Terminate task due to unrecoverable error.");
                    response.terminate();
                }
            }
            Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.AnalyzeConsoleIntCodePanelHandler.service()");
        }
    };
    private PanelHandler AcceptedUpdatesPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.AcceptedUpdatesPanelHandler.service()");
            AnalyzeConsoleIntCodeTasklet.this.currentPanel = AnalyzeConsoleIntCodeTasklet.this.AnalyzeConsoleIntCodePanelHandler;
            response.dispose();
            Trace.trace(AnalyzeConsoleIntCodeTasklet.TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.AcceptedUpdatesPanelHandler.service()");
        }
    };

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.service()");
        try {
            if (request.isInitialRequest()) {
                this.showBusyDialog(new LocalizableText(baseBundleName, "updates.analyze.busy.title"), new LocalizableText(baseBundleName, "updates.analyze.busy.text"));
                this.allUpdatesList = this.theUpdateManager.getTowerUpdates();
                List styles = this.theUpdateManager.getUpdateStylesUsedByUpdate(this.allUpdatesList);
                Trace.trace(TRACE_MASKD, " [AnalyzeConsoleIntCodeTasklet.service()] There are " + Integer.toString(styles.size()) + " styles associated with the list of updates.");
                if (styles.size() > 0) {
                    this.updateStyle = (UpdateStyle)styles.get(0);
                }
                this.refreshLocalUpdateData(null);
                AnalyzeConsoleIntCodeBean bean = new AnalyzeConsoleIntCodeBean();
                bean.refreshData(this.getResponseData());
                bean.setChangeConsoleSubtaskletStatus(false);
                this.destroyBusyDialog();
                this.currentPanel = this.AnalyzeConsoleIntCodePanelHandler;
                response.replace("com.ibm.hwmca.base.updates.res.AnalyzeConsoleIntCodeRes", "AnalyzeConsoleIntCodePanel", bean);
            } else {
                this.currentPanel.service(request, response);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, " [AnalyzeConsoleIntCodeTasklet.service()] caught exception: " + e);
            e.printStackTrace();
            new FrameworkLog(classLogInfo, -4348, e).log();
            Trace.trace(TRACE_MASKT, " [AnalyzeConsoleIntCodeTasklet.service()] Terminate task due to unrecoverable error.");
            response.terminate();
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.service()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleRetrieveRequest(PanelTaskletResponse response) throws TaskletException {
        String msgTitleKey;
        String msgTextKey;
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest()");
        if (this.mediaType == 1) {
            msgTextKey = "MCL0019";
            msgTitleKey = "MCL8016";
        } else {
            msgTextKey = "MCL0020";
            msgTitleKey = "MCL8017";
        }
        LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
        boolean continueTask = this.isUserContinuingAfterMsg(msgTitleKey, msgTextKey, null, buttons);
        if (!continueTask) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - User canceled from the 'insert media' panel.");
            response.noAction();
            return;
        }
        MediaServicesUtil myMSU = new MediaServicesUtil(this);
        LocalizableText whoIam = new LocalizableText(baseBundleName, "updates.analyze.mediaservices.name");
        this.busyMessage = new LocalizableText(baseBundleName, "updates.analyze.busy.text.import");
        try {
            myMSU.prepareMedia(this.mediaType, whoIam, false, null);
            MediaDevice mediaDevice = myMSU.getMediaDevice();
            this.searchArea = mediaDevice.getMountPoint();
        }
        catch (MediaServicesUtilException msue) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - media not available");
            response.noAction();
            return;
        }
        catch (MediaDeviceException mde) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - MediaDeviceException!! - " + mde.getMessage());
            FrameworkLog log = new FrameworkLog(classLogInfo, -4345, mde);
            log.log(FrameworkLogAttributes.INFO_LOG);
            response.noAction();
            return;
        }
        List mcfList = this.countMcfsToImport(this.searchArea);
        Object var12_14 = null;
        try {
            myMSU.releaseMedia();
        }
        catch (MediaServicesUtilException msue) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - MediaServiceUtilException from releaseMedia()!! - " + msue.getMessage());
            FrameworkLog log2 = new FrameworkLog(classLogInfo, -4344, msue);
            log2.log(FrameworkLogAttributes.INFO_LOG);
            response.noAction();
            return;
        }
        {
            catch (Exception ioe) {
                Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - IOException from .countMcfsToImport()!! Someone must have messed with the removable media  - The IOException was: " + ioe.getMessage());
                FrameworkLog log = new FrameworkLog(classLogInfo, -4343, ioe);
                log.log(FrameworkLogAttributes.INFO_LOG);
                response.noAction();
                Object var12_15 = null;
                try {
                    myMSU.releaseMedia();
                }
                catch (MediaServicesUtilException msue) {
                    Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - MediaServiceUtilException from releaseMedia()!! - " + msue.getMessage());
                    FrameworkLog log2 = new FrameworkLog(classLogInfo, -4344, msue);
                    log2.log(FrameworkLogAttributes.INFO_LOG);
                    response.noAction();
                    return;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                myMSU.releaseMedia();
            }
            catch (MediaServicesUtilException msue) {
                Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - MediaServiceUtilException from releaseMedia()!! - " + msue.getMessage());
                FrameworkLog log2 = new FrameworkLog(classLogInfo, -4344, msue);
                log2.log(FrameworkLogAttributes.INFO_LOG);
                response.noAction();
                return;
            }
            throw throwable;
        }
        if (mcfList.isEmpty()) {
            this.showMessage("MCF8007", "MCF0007");
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - No MCFs to import");
            response.noAction();
            return;
        }
        int estimatedDuration = mcfList.size() * 60;
        String estimatedTimeSubstitution = new Integer(mcfList.size()).toString();
        String[] subData = new String[]{estimatedTimeSubstitution};
        LocalizableText importButton = new LocalizableText(baseBundleName, "updates.importexport.button");
        buttons = new LocalizableText[]{importButton, CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON};
        continueTask = this.isUserContinuingAfterMsg("MCF8006", "MCF0006", subData, buttons);
        if (!continueTask) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - User canceled from the confirmation panel.");
            response.noAction();
            return;
        }
        try {
            myMSU.prepareMedia(this.mediaType, whoIam, false, null);
            MediaDevice mediaDevice = myMSU.getMediaDevice();
            this.searchArea = mediaDevice.getMountPoint();
        }
        catch (HException he) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - media not available when setting up for import");
            FrameworkLog log = new FrameworkLog(classLogInfo, -4342, he);
            log.log(FrameworkLogAttributes.INFO_LOG);
            response.noAction();
            return;
        }
        try {
            LocalizableText progPanelStartMsg = new LocalizableText(baseBundleName, "updates.importstart.text");
            this.savedProgListener = new PanelTaskletProgressListener(this);
            ProgressStartEvent startEvent = new ProgressStartEvent(new BaseMessageTitle("MCF8001"), new ProgressData[]{new ProgressData()}, (long)estimatedDuration, progPanelStartMsg, PROGRESS_PANEL_ID, (ProgressCancelListener)null, (ProgressEndedListener)this);
            this.savedProgListener.startProgress(startEvent);
            AnalyzeConsoleIntCodeTasklet analyzeConsoleIntCodeTasklet = this;
            synchronized (analyzeConsoleIntCodeTasklet) {
                this.progressDismissed = false;
                String textKey = "updates.importexportdone.text";
                this.importCompletionMessage = new LocalizableText(baseBundleName, textKey);
                int completionStatus = 1;
                try {
                    this.importMcfs(mcfList);
                }
                catch (HException he) {
                    completionStatus = 2;
                }
                ProgressData progData = new ProgressData(this.importCompletionMessage);
                progData.setCompletionStatus(completionStatus);
                ProgressUpdateEvent progUpdateEvent = new ProgressUpdateEvent(progData, PROGRESS_PANEL_ID);
                this.savedProgListener.updateProgress(progUpdateEvent);
                this.savedProgListener.endProgress(new ProgressEndEvent(PROGRESS_PANEL_ID));
                while (!this.progressDismissed) {
                    try {
                        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - entering wait()");
                        this.wait();
                        Trace.trace(TRACE_MASKF, "   ChangeConsoleIntCodeTasklet.doImportExport() - leaving wait()");
                    }
                    catch (InterruptedException exc) {}
                }
            }
            Object var23_39 = null;
        }
        catch (Throwable throwable) {
            Object var23_40 = null;
            try {
                myMSU.releaseMedia();
            }
            catch (MediaServicesUtilException msue) {
                Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - MediaServiceUtilException from releaseMedia()!! - " + msue.getMessage());
                FrameworkLog log = new FrameworkLog(classLogInfo, -4341, msue);
                log.log(FrameworkLogAttributes.INFO_LOG);
            }
            throw throwable;
        }
        try {
            myMSU.releaseMedia();
        }
        catch (MediaServicesUtilException msue) {
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest() - MediaServiceUtilException from releaseMedia()!! - " + msue.getMessage());
            FrameworkLog log = new FrameworkLog(classLogInfo, -4341, msue);
            log.log(FrameworkLogAttributes.INFO_LOG);
        }
        this.showBusyDialog(new LocalizableText(baseBundleName, "updates.analyze.busy.title"), new LocalizableText(baseBundleName, "updates.analyze.busy.text"));
        this.allUpdatesList = this.theUpdateManager.getTowerUpdates();
        List styles = this.theUpdateManager.getUpdateStylesUsedByUpdate(this.allUpdatesList);
        Trace.trace(TRACE_MASKD, "   AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest - There are " + Integer.toString(styles.size()) + " styles associated with the list of updates.");
        if (styles.size() > 0) {
            this.updateStyle = (UpdateStyle)styles.get(0);
        }
        this.refreshLocalUpdateData(null);
        AnalyzeConsoleIntCodeBean bean = new AnalyzeConsoleIntCodeBean();
        bean.refreshData(this.getResponseData());
        bean.setChangeConsoleSubtaskletStatus(false);
        this.destroyBusyDialog();
        this.currentPanel = this.AnalyzeConsoleIntCodePanelHandler;
        response.replace("com.ibm.hwmca.base.updates.res.AnalyzeConsoleIntCodeRes", "AnalyzeConsoleIntCodePanel", bean);
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.handleRetrieveRequest()");
    }

    public List countMcfsToImport(File source) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.countMcfsToImport() - source path is [" + source.getPath() + "]");
        ArrayList<McfInfo> mcfsFound = new ArrayList<McfInfo>();
        List streams = this.theUpdateManager.getTowerUpdateableComponents();
        ListIterator counterOfStreams = streams.listIterator();
        String sourcePath = source.getPath();
        while (counterOfStreams.hasNext()) {
            UpdateableComponent nextUpdateableComponent = (UpdateableComponent)counterOfStreams.next();
            if (!(nextUpdateableComponent instanceof ECStream)) continue;
            ECStream ecStream = (ECStream)nextUpdateableComponent;
            AllMCFFileFilter filter = new AllMCFFileFilter(ecStream);
            String[] files = source.list(filter);
            for (int i = 0; i < files.length; ++i) {
                String fullName = sourcePath + File.separator + files[i];
                mcfsFound.add(new McfInfo(fullName, ecStream));
                Trace.trace(TRACE_MASKT, "   AnalyzeConsoleIntCodeTasklet.countMcfsToImport() - added [" + fullName + "] to MCF control file list.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.countMcfsToImport() - " + mcfsFound.size() + " MCF control file(s) were found");
        return mcfsFound;
    }

    public void importMcfs(List mcfList) throws HException {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.importMcfs()");
        String stagingArea = "";
        try {
            stagingArea = BaseFileControl.getFilePath("iqzmcf.mcf");
        }
        catch (HException he) {
            String textKey = "updates.analyze.completion.failure";
            this.importCompletionMessage = new LocalizableText(baseBundleName, textKey);
            throw he;
        }
        ListIterator mcfListIterator = mcfList.listIterator();
        while (mcfListIterator.hasNext()) {
            McfInfo mcfInfo = (McfInfo)mcfListIterator.next();
            String mcfFileName = mcfInfo.getFile();
            ECStream mcfEcStream = mcfInfo.getStream();
            int lastSlash = mcfFileName.lastIndexOf(File.separatorChar);
            String onlyName = mcfFileName.substring(lastSlash + 1);
            String onlyPath = mcfFileName.substring(0, lastSlash);
            int dotPos = onlyName.indexOf(46);
            String mcfCtlFileName = stagingArea + onlyName.substring(0, dotPos) + ".xml";
            Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.importMcfs() - processing file [" + mcfFileName + "]" + " - onlyName is [" + onlyName + "]" + " - onlyPath is [" + onlyPath + "]" + " - control file [" + mcfCtlFileName + "]");
            File tFile = new File(mcfCtlFileName);
            if (tFile.exists()) {
                Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.importMcfs() - error processing file [" + mcfFileName + "]" + " - file already exists, replace not allowed");
                FrameworkLog log = new FrameworkLog(classLogInfo, -4336);
                log.log(FrameworkLogAttributes.INFO_LOG);
                String textKey = "updates.analyze.completion.warning";
                this.importCompletionMessage = new LocalizableText(baseBundleName, textKey);
                continue;
            }
            IssueCmd cmd = new IssueCmd();
            int rc = cmd.execute("cp -i --reply=no " + mcfFileName + " " + stagingArea);
            if (0 != rc) {
                Trace.trace(TRACE_MASKF, "   AnalyzeConsoleIntCodeTasklet.importMcfs() - error processing file [" + mcfFileName + "]" + " - error was [" + cmd.getErrorOutput() + "]");
                FrameworkLog log = new FrameworkLog(classLogInfo, -4340);
                log.log(FrameworkLogAttributes.INFO_LOG);
                String textKey = "updates.analyze.completion.warning";
                this.importCompletionMessage = new LocalizableText(baseBundleName, textKey);
                continue;
            }
            String mcfZipFileName = stagingArea + onlyName;
            Trace.trace(TRACE_MASKD, "   MCF .zip data file [" + mcfZipFileName + "] exists. Unpack it.");
            try {
                MCF.unpackMcf(onlyName);
            }
            catch (HException he) {}
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.importMcfs()");
    }

    private boolean isUserContinuingAfterMsg(String titleKey, String messageKey, String[] substitutions, LocalizableText[] options) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.isUserContinuingAfterMsg");
        boolean firstButtonFlag = false;
        LocalizableText buttonPressed = this.showMessage(titleKey, messageKey, substitutions, options);
        if (null != buttonPressed) {
            Trace.trace(TRACE_MASKD, " [isUserContinuingAfterMsg] Button pressed on message box was '" + buttonPressed + "'");
        }
        if (null != buttonPressed) {
            if (null != options) {
                if (buttonPressed.toString().equals(options[0].toString())) {
                    firstButtonFlag = true;
                }
            } else if (buttonPressed.toString().equals(CommonMsgInterface.OK_BUTTON.toString()) || buttonPressed.toString().equals(CommonMsgInterface.YES_BUTTON.toString())) {
                firstButtonFlag = true;
            }
        }
        Trace.trace(TRACE_MASKF, " [isUserContinuingAfterMsg] returning '" + firstButtonFlag + "'");
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.isUserContinuingAfterMsg");
        return firstButtonFlag;
    }

    private LocalizableText showMessage(String titleKey, String messageKey, String[] substitutions, LocalizableText[] options) {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeTasklet.showMessage");
        LocalizableText buttonPressed = null;
        try {
            BaseMessageText message = null == substitutions ? new BaseMessageText(messageKey) : new BaseMessageText(messageKey, substitutions);
            buttonPressed = this.showMessageBox(true, new BaseMessageTitle(titleKey), message, null, options);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, " [showMessage] Exception working with message box!");
        }
        return buttonPressed;
    }

    void refreshLocalUpdateData(List changedRows) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.refreshLocalUpdateData()");
        if (null == changedRows) {
            int numRows = null == this.allUpdatesList ? 0 : this.allUpdatesList.size();
            this.tableData = new ArrayList(numRows);
            UserContext userContext = UserContext.getCurrentUserContext();
            DateFormat dfDate = DateFormat.getDateInstance(3, userContext.getLocale());
            dfDate.setTimeZone(userContext.getTimeZone());
            DateFormat dfTime = DateFormat.getTimeInstance(3, userContext.getLocale());
            dfTime.setTimeZone(userContext.getTimeZone());
            for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
                Update currentUpdate = (Update)this.allUpdatesList.get(rowIndex);
                String[] rowData = new String[7];
                rowData[0] = currentUpdate.getUpdateableComponent().getECNumber();
                rowData[1] = currentUpdate.getDisplayableId();
                UpdateCollection uc = currentUpdate.getCollection();
                rowData[2] = null == uc ? "000" : uc.getDisplayableId();
                rowData[3] = currentUpdate.getDisplayableState().toString();
                Date theDate = currentUpdate.getLastStatusChangeDate();
                if (null != theDate) {
                    rowData[4] = dfDate.format(theDate);
                    rowData[5] = dfTime.format(theDate);
                } else {
                    rowData[4] = "";
                    rowData[5] = "";
                }
                LocalizableText theDescription = currentUpdate.getDescription();
                rowData[6] = null != theDescription ? theDescription.toString() : "";
                this.tableData.add(rowData);
            }
        } else {
            UserContext userContext = UserContext.getCurrentUserContext();
            DateFormat dfDate = DateFormat.getDateInstance(3, userContext.getLocale());
            dfDate.setTimeZone(userContext.getTimeZone());
            DateFormat dfTime = DateFormat.getTimeInstance(3, userContext.getLocale());
            dfTime.setTimeZone(userContext.getTimeZone());
            Iterator iterator = changedRows.iterator();
            while (iterator.hasNext()) {
                int rowIndex = (Integer)iterator.next();
                Update currentUpdate = (Update)this.allUpdatesList.get(rowIndex);
                String[] rowData = (String[])this.tableData.get(rowIndex);
                rowData[3] = currentUpdate.getDisplayableState().toString();
                Date theDate = currentUpdate.getLastStatusChangeDate();
                if (null != theDate) {
                    rowData[4] = dfDate.format(theDate);
                    rowData[5] = dfTime.format(theDate);
                } else {
                    rowData[4] = "";
                    rowData[5] = "";
                }
                this.tableData.set(rowIndex, rowData);
            }
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.refreshLocalUpdateData()");
    }

    private List getAllCommittedUpdates() {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.getAllCommittedUpdates()");
        ArrayList<String[]> commitTableData = new ArrayList<String[]>();
        UserContext userContext = UserContext.getCurrentUserContext();
        DateFormat dfDate = DateFormat.getDateInstance(3, userContext.getLocale());
        dfDate.setTimeZone(userContext.getTimeZone());
        DateFormat dfTime = DateFormat.getTimeInstance(3, userContext.getLocale());
        dfTime.setTimeZone(userContext.getTimeZone());
        List components = this.theUpdateManager.getTowerUpdateableComponents();
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UpdateableComponent component = (UpdateableComponent)iterator.next();
            List committedUpdates = component.getCommittedUpdates();
            Iterator jiterator = committedUpdates.iterator();
            while (jiterator.hasNext()) {
                Update currentUpdate = (Update)jiterator.next();
                String[] rowData = new String[7];
                rowData[0] = currentUpdate.getUpdateableComponent().getECNumber();
                rowData[1] = currentUpdate.getDisplayableId();
                UpdateCollection uc = currentUpdate.getCollection();
                rowData[2] = null == uc ? "000" : uc.getDisplayableId();
                Date theDate = currentUpdate.getLastStatusChangeDate();
                if (null != theDate) {
                    rowData[3] = dfDate.format(theDate);
                    rowData[4] = dfTime.format(theDate);
                } else {
                    rowData[3] = "";
                    rowData[4] = "";
                }
                LocalizableText theDescription = currentUpdate.getDescription();
                rowData[5] = null != theDescription ? theDescription.toString() : "";
                commitTableData.add(rowData);
            }
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.getAllCommittedUpdates()");
        return commitTableData;
    }

    AnalyzeConsoleIntCodeResponseData getResponseData() {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.getResponseData()");
        AnalyzeConsoleIntCodeResponseData responseData = new AnalyzeConsoleIntCodeResponseData();
        responseData.setTableData(this.tableData);
        String textKey = this.theUpdateManager.isUpdatingFullyEnabled() ? "updates.enabled.text" : "updates.disabled.text";
        responseData.setChangeManagementStatus(new LocalizableText(baseBundleName, textKey).toString());
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.getResponseData()");
        return responseData;
    }

    private void showMessage(String titleKey, String messageKey) {
        try {
            this.showMessageBox(true, new BaseMessageTitle(titleKey), new BaseMessageText(messageKey), null, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, " [showMessage] Exception working with message box!");
        }
    }

    private void showMessage(String titleKey, String messageKey, String[] substitutions, List messageList) {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeTasklet.showMessage");
        try {
            BaseMessageText introMsg = new BaseMessageText(messageKey, substitutions);
            messageList.add(0, introMsg);
            MessageText[] messageArray = messageList.toArray(new MessageText[0]);
            this.showMessageBox(true, new BaseMessageTitle(titleKey), messageArray, introMsg.getMsgId(), null, null);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, " [showMessage] Exception working with message box!");
        }
    }

    Update getSelectedUpdate() {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeTasklet.getSelectedUpdate()");
        return this.selectedUpdate;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.logException()");
        Trace.trace(TRACE_MASKT, "   processing exception: " + throwable);
        new FrameworkLog(classLogInfo, -4349, throwable).log();
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.logException()");
    }

    public boolean isBusyDesired() {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeTasklet.isBusyDesired() - " + this.isBusyDesiredForMediaOperations);
        return this.isBusyDesiredForMediaOperations;
    }

    public LocalizableText getBusyMessage() {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeTasklet.getBusyMessage() -  returning [" + this.busyMessage + "]");
        return this.busyMessage;
    }

    public PanelTasklet getPanelTasklet() {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeTasklet.getPanelTasklet() -  returning ourself");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeTasklet.progressEnded()");
        AnalyzeConsoleIntCodeTasklet analyzeConsoleIntCodeTasklet = this;
        synchronized (analyzeConsoleIntCodeTasklet) {
            this.progressDismissed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeTasklet.progressEnded()");
    }

    static class McfInfo {
        private String file;
        private ECStream stream;

        McfInfo(String mcfControlFile, ECStream ecStream) {
            this.file = mcfControlFile;
            this.stream = ecStream;
        }

        String getFile() {
            return this.file;
        }

        ECStream getStream() {
            return this.stream;
        }
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

